/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

class CVideoOverlayMixerProperties : public CBasePropertyPage
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:

    BOOL	OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT	OnConnect(IUnknown *pUnknown);
    HRESULT	OnDisconnect();
    HRESULT	OnDeactivate();
    HRESULT	OnApplyChanges();

    void	SetDirty();
	void	SetupItems();

    CVideoOverlayMixerProperties(LPUNKNOWN lpunk, HRESULT *phr);
	
	unsigned int	_iTimeStamp;
	unsigned int	_iTimeStampOnExit;
	bool			_bTimeStampZero;
	bool			_bTimeStampZeroOnExit;
	int				_iTimeOffset;
	int				_iTimeOffsetOnExit;
	int				_iFrameRate;
	int				_iFrameRateOnExit;
	unsigned int	_iMask;
	unsigned int	_iMaskOnExit;
	unsigned int	_iBlending;
	unsigned int	_iBlendingOnExit;
	int				_iCompPosX;
	int				_iCompPosXOnExit;
	int				_iCompPosY;
	int				_iCompPosYOnExit;
	bool			_bPointerInDisable;
	bool			_bPointerInDisableOnExit;
	unsigned int	_iGridX;
	unsigned int	_iGridXOnExit;
	unsigned int	_iGridY;
	unsigned int	_iGridYOnExit;

    IVideoOverlayMixer *m_pVideoOverlayMixer;

    IVideoOverlayMixer *pIVideoOverlayMixer() {
        ASSERT(m_pVideoOverlayMixer);
        return m_pVideoOverlayMixer;
    };

}; // CVideoOverlayMixerProperties

