/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __VIDEOQUADSPLITTER_H__
#define __VIDEOQUADSPLITTER_H__


class CVideoQuadSplitter : public CCpndBase2Filter,
		public CPersistStream, 
		public IVideoQuadSplitter,
		public ISpecifyPropertyPages
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

	// Reveals IVideoQuadSplitter & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    DECLARE_IUNKNOWN;

	HRESULT			Transform(IMediaSample **ppInputs, IMediaSample *pOut);
    HRESULT			CheckInputType(const CMediaType *mtIn, unsigned int pinIdx);
	HRESULT			CheckOutputType(const CMediaType *mtOut);
	HRESULT			GetMediaType(int iPosition, CMediaType *pMediaType);
    HRESULT			DecideBufferSize(IMemAllocator *pAlloc,
                             ALLOCATOR_PROPERTIES *pProperties);

    virtual HRESULT	SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt, unsigned int pinIdx);

	
    // IVideoQuadSplitter methods
	STDMETHODIMP	get_TimeStamp(unsigned int *timeStamp);
	STDMETHODIMP	put_TimeStamp(unsigned int timeStamp);
	STDMETHODIMP	get_TimeStampZero(bool *flag);
	STDMETHODIMP	put_TimeStampZero(bool flag);
	STDMETHODIMP	get_TimeOffset(int *timeOffset);
	STDMETHODIMP	put_TimeOffset(int timeOffset);
	STDMETHODIMP	get_BackgroundColor(unsigned int *bgColor);
	STDMETHODIMP	put_BackgroundColor(unsigned int bgColor);
	STDMETHODIMP	get_FrameRate(int *rate);
	STDMETHODIMP	put_FrameRate(int rate);
	STDMETHODIMP	get_BorderLineOn(bool *flag);
	STDMETHODIMP	put_BorderLineOn(bool flag);

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax ();


    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

private:

    // Constructor
    CVideoQuadSplitter(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CVideoQuadSplitter();

	HRESULT			Fill(IMediaSample *pDest, unsigned int place) const;
	HRESULT			Compound(IMediaSample *pSource, IMediaSample *pDest, unsigned int place) const;
	HRESULT			DrawBorderLine(IMediaSample *pSource) const;
	HRESULT			SetupProp(IMediaSample* pSource, IMediaSample* pDest) const;

	HRESULT			AllocBaseBuffer(unsigned int size);
	HRESULT			DrawBaseBufferInBGColor();

private:

    // Non interface locking critical section
    CCritSec			m_VideoQuadSplitterLock;

	TimeStampEnum		_timeStamp;
	BackgroundColorEnum	_bgColor;
	bool				_borderLineOn;
	bool				_qualityHi;

	int					_baseBufSize;
	BYTE*				_baseBuf;
	int					m_iNonCnt0;
	int					m_iNonCnt1;
	int					m_iNonCnt2;
	int					m_iNonCnt3;

}; // CVideoQuadSplitter

#endif
