/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#include <streams.h>
#include <commctrl.h>
#include <olectl.h>
#include <memory.h>
#include "resource.h"

#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include <flTypes/flUIDs.h>
#include <flTypes/IVideoQuadSplitter.h>

#include "cpndbase2.h"

#include "videoquadsplitter.h"
#include "videoquadsplitterprop.h"

//
// CreateInstance
//
// This goes in the factory template table to create new filter instances
//
CUnknown * WINAPI CVideoQuadSplitterProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CVideoQuadSplitterProperties(lpunk, phr);
    if (punk == NULL) {
	*phr = E_OUTOFMEMORY;
    }
    return punk;

} // CreateInstance


//
// Constructor
//
CVideoQuadSplitterProperties::CVideoQuadSplitterProperties(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("VideoQuadSplitterProp"),pUnk,
                      IDD_VIDEOQUADSPLITTERPROP,
                      IDS_TITLE),
    m_pVideoQuadSplitter(NULL)
{
    InitCommonControls();

} // (Constructor)


//
// SetDirty
//
// Sets m_bDirty and notifies the property page site of the change
//
void CVideoQuadSplitterProperties::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite) {
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

} // SetDirty


//
// OnReceiveMessage
//
// Virtual method called by base class with Window messages
//
BOOL CVideoQuadSplitterProperties::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			SetupItems();

			if (_iTimeStamp == 4)
			{
				Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), true);
			} else {
				Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), false);
			}

			return (LRESULT) 1;

		}
        case WM_COMMAND:
        {

			switch(LOWORD(wParam))
			{
			case IDC_TIME_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_TIME_COMBO));
					pIVideoQuadSplitter()->put_TimeStamp(sel);

					if (sel == 4)
					{
						Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), true);
					} else {
						Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), false);
					}

					SetDirty();
				}
				break;
			case IDC_TIMESTAMPZERO_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK)) == TRUE);
					pIVideoQuadSplitter()->put_TimeStampZero(flag);

					SetDirty();
				}
				break;
			case IDC_TIMEOFFSET_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int timeOffset;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), sz, STR_MAX_LENGTH);
					timeOffset = atoi(sz);
					pIVideoQuadSplitter()->put_TimeOffset(timeOffset);

					SetDirty();
				}
				break;
			case IDC_BGCOLOR_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO));
					pIVideoQuadSplitter()->put_BackgroundColor(sel);
					SetDirty();
				}
				break;
			case IDC_FRAMERATE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int rate;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz, STR_MAX_LENGTH);
					rate = atoi(sz);
					pIVideoQuadSplitter()->put_FrameRate(rate);

					SetDirty();
				}
				break;
			case IDC_BORDERLINEON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_BORDERLINEON_CHECK)) == TRUE);
					pIVideoQuadSplitter()->put_BorderLineOn(flag);

					SetDirty();
				}
				break;
			}

			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd, uMsg, wParam, lParam);

} // OnReceiveMessage


//
// OnConnect
//
// Called when the property page connects to a filter
//
HRESULT CVideoQuadSplitterProperties::OnConnect(IUnknown *pUnknown)
{
    ASSERT(m_pVideoQuadSplitter == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IVideoQuadSplitter, (void **) &m_pVideoQuadSplitter);
    if (FAILED(hr)) {
        return E_NOINTERFACE;
    }

    ASSERT(m_pVideoQuadSplitter);

	m_pVideoQuadSplitter->get_TimeStamp(&_iTimeStamp);
	_iTimeStampOnExit = _iTimeStamp;

	m_pVideoQuadSplitter->get_TimeStampZero(&_bTimeStampZero);
	_bTimeStampZeroOnExit = _bTimeStampZero;

	m_pVideoQuadSplitter->get_TimeOffset(&_iTimeOffset);
	_iTimeOffsetOnExit = _iTimeOffset;

	m_pVideoQuadSplitter->get_BackgroundColor(&_iBGColor);
	_iBGColorOnExit = _iBGColor;

	m_pVideoQuadSplitter->get_FrameRate(&_iFrameRate);
	_iFrameRateOnExit = _iFrameRate;

	m_pVideoQuadSplitter->get_BorderLineOn(&_bBorderLineOn);
	_bBorderLineOnOnExit = _bBorderLineOn;

	return NOERROR;

} // OnConnect


//
// OnDisconnect
//
// Called when we're disconnected from a filter
//
HRESULT CVideoQuadSplitterProperties::OnDisconnect()
{
    if (m_pVideoQuadSplitter == NULL) {
        return E_UNEXPECTED;
    }

	m_pVideoQuadSplitter->put_TimeStamp(_iTimeStampOnExit);
	m_pVideoQuadSplitter->put_TimeStampZero(_bTimeStampZeroOnExit);
	m_pVideoQuadSplitter->put_TimeOffset(_iTimeOffsetOnExit);
	m_pVideoQuadSplitter->put_BackgroundColor(_iBGColorOnExit);
	m_pVideoQuadSplitter->put_FrameRate(_iFrameRateOnExit);
	m_pVideoQuadSplitter->put_BorderLineOn(_bBorderLineOnOnExit);

    m_pVideoQuadSplitter->Release();
    m_pVideoQuadSplitter = NULL;
    return NOERROR;

} // OnDisconnect


//
// OnDeactivate
//
// We are being deactivated
//
HRESULT CVideoQuadSplitterProperties::OnDeactivate(void)
{
	pIVideoQuadSplitter()->get_TimeStamp(&_iTimeStamp);
	pIVideoQuadSplitter()->get_TimeStampZero(&_bTimeStampZero);
	pIVideoQuadSplitter()->get_TimeOffset(&_iTimeOffset);
	pIVideoQuadSplitter()->get_BackgroundColor(&_iBGColor);
	pIVideoQuadSplitter()->get_FrameRate(&_iFrameRate);
	pIVideoQuadSplitter()->get_BorderLineOn(&_bBorderLineOn);

	return NOERROR;

} // OnDeactivate


//
// OnApplyChanges
//
// Changes made should be kept. Change the m_cVideoQuadSplitterOnExit variable
//
HRESULT CVideoQuadSplitterProperties::OnApplyChanges()
{
	pIVideoQuadSplitter()->get_TimeStamp(&_iTimeStampOnExit);
	pIVideoQuadSplitter()->get_TimeStampZero(&_bTimeStampZeroOnExit);
	pIVideoQuadSplitter()->get_TimeOffset(&_iTimeOffsetOnExit);
	pIVideoQuadSplitter()->get_BackgroundColor(&_iBGColorOnExit);
	pIVideoQuadSplitter()->get_FrameRate(&_iFrameRateOnExit);
	pIVideoQuadSplitter()->get_BorderLineOn(&_bBorderLineOnOnExit);

    m_bDirty = FALSE;
    return(NOERROR);

} // OnApplyChanges

void
CVideoQuadSplitterProperties::SetupItems()
{
	ComboBox_ResetContent(m_Dlg);
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("0"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("1"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("2"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("3"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("Ǝ"));


	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));

    TCHAR   sz[32];

	// Time Stamp
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _iTimeStamp);
	// Time Stamp on
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), _bTimeStampZero);
	// Time Offset
    _stprintf(sz, TEXT("%d"), _iTimeOffset);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), sz);
	// Background Color
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _iBGColor);
	// Framerate
    _stprintf(sz, TEXT("%d"), _iFrameRate);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz);
	// Border Line on
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_BORDERLINEON_CHECK), _bBorderLineOn);

}




