/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

class CVideoQuadSplitterProperties : public CBasePropertyPage
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:

    BOOL	OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT	OnConnect(IUnknown *pUnknown);
    HRESULT	OnDisconnect();
    HRESULT	OnDeactivate();
    HRESULT	OnApplyChanges();

    void	SetDirty();
	void	SetupItems();

    CVideoQuadSplitterProperties(LPUNKNOWN lpunk, HRESULT *phr);
	
	unsigned int	_iTimeStamp;
	unsigned int	_iTimeStampOnExit;
	bool			_bTimeStampZero;
	bool			_bTimeStampZeroOnExit;
	int				_iTimeOffset;
	int				_iTimeOffsetOnExit;
	unsigned int	_iBGColor;
	unsigned int	_iBGColorOnExit;
	int				_iFrameRate;
	int				_iFrameRateOnExit;
	bool			_bBorderLineOn;
	bool			_bBorderLineOnOnExit;


    IVideoQuadSplitter *m_pVideoQuadSplitter;

    IVideoQuadSplitter *pIVideoQuadSplitter() {
        ASSERT(m_pVideoQuadSplitter);
        return m_pVideoQuadSplitter;
    };

}; // CVideoQuadSplitterProperties

