/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __VolumeGraph_h__
#define __VolumeGraph_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flVolumeGraph/_IVolumeGraph.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IVolumeGraph.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#define MAXIMUM_VIDEOGRAPHPINS		1024
//------------------------------------------------------------------------------
class flPCMAudio;
class flAbsoluteTime;
class CVolumeGraphInputPin;
class CVolumeGraphOutputPin;
//------------------------------------------------------------------------------
class CVolumeGraph : public CBaseFilter,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IVolumeGraph,
		public _IVolumeGraph
{
	friend class CVolumeGraphInputPin;
	friend class CVolumeGraphOutputPin;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CVolumeGraph(TCHAR *pName, LPUNKNOWN punk, HRESULT *phr);
	~CVolumeGraph();

public:
    STDMETHODIMP		NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
    virtual	int			GetPinCount();
    virtual CBasePin*	GetPin(int n);
    STDMETHODIMP		FindPin(LPCWSTR Id, IPin **ppPin);

	STDMETHODIMP		Stop();
	STDMETHODIMP		Pause();

	// IPersistStream
    STDMETHODIMP		GetClassID(CLSID *pClsid);
	HRESULT				WriteToStream(IStream *pStream);
    HRESULT				ReadFromStream(IStream *pStream);
	DWORD				GetSoftwareVersion(void);
	int					SizeMax();

    // ISpecifyPropertyPages
    STDMETHODIMP		GetPages(CAUUID *pPages);

    // IVolumeGraph
	STDMETHODIMP		get_NumInputs(flUInt *numInputs);
	STDMETHODIMP		get_Volume(flUInt inputIndex, VolumeInfo *volume);
	STDMETHODIMP		get_EvaluationTime(flULong* evalTime);
	STDMETHODIMP		put_EvaluationTime(flULong evalTime);
	STDMETHODIMP		get_DisplayTime(flInt* displayTime);
	STDMETHODIMP		put_DisplayTime(flInt displayTime);

private:
	CBasePin*			GetInputPin(CBasePin* outputPin);
	CBasePin*			GetOutputPin(CBasePin* inputPin);
	CCritSec*			GetReceiveLock(CBasePin* inputPin);

	// Called Input/Output
	HRESULT				CheckMediaType(CBasePin* pin, const CMediaType *pmt);

	// Called Input
	HRESULT				SetMediaType(CBasePin* inputPin, const CMediaType *pmt);
	HRESULT				Receive(CBasePin* inputPin, IMediaSample* pSample);
	HRESULT				EndOfStream(CBasePin* inputPin);
	HRESULT				BeginFlush(CBasePin* inputPin);
	HRESULT				EndFlush(CBasePin* inputPin);
	HRESULT				NewSegment(CBasePin* inputPin,	REFERENCE_TIME tStart,
														REFERENCE_TIME tStop,
														double dRate);

	// Called Output
    HRESULT				DecideBufferSize(CBasePin* outputPin,
										IMemAllocator * pAlloc,
										ALLOCATOR_PROPERTIES *pProp);
	HRESULT				GetMediaType(CBasePin* outputPin, CMediaType *pmt);

	// Pin Creation
	void				InitVolumeGraphInOutPins();
	void				CreateInOutPin();
	void				DeleteInPin(CVolumeGraphInputPin* inputPin);
	void				DeleteOutPin(CVolumeGraphOutputPin* outputPin);
	flUInt				GetNumFreeInputPins();

private:
	flInt				GetInputPinIndex(CBasePin* inputPin);
	flInt				GetOutputPinIndex(CBasePin* outputPin);

protected:
	// Ciritcal Section for filter
    CCritSec							_filterLock;

	flAbsoluteTime*						_absTime;

	flUInt								_nextPinNumber;
	flArray<CCritSec *>					_receiveLocks;
	flArray<CVolumeGraphInputPin *>		_inputPins;
	flArray<CVolumeGraphOutputPin *>	_outputPins;

	flArray<CCritSec *>					_pcmAudioLocks;
	flArray<flPCMAudio *>				_pcmAudios;

	flULong								_evalTime;
	flInt								_displayTime;
};
//------------------------------------------------------------------------------
#endif // __VolumeGraph_h__
