/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __VolumeGraphInputPin_h__
#define __VolumeGraphInputPin_h__
//------------------------------------------------------------------------------
#include <flVolumeGraph/VolumeGraph.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CVolumeGraph;
//------------------------------------------------------------------------------
class CVolumeGraphInputPin : public CBaseInputPin
{
	friend class CVolumeGraph;

public:
	CVolumeGraphInputPin(TCHAR *pObjectName,
						CVolumeGraph *pVolumeGraph,
						HRESULT * phr,
						LPCWSTR pName);
	~CVolumeGraphInputPin();

public:
	STDMETHODIMP			QueryId(LPWSTR * Id);

	STDMETHODIMP_(ULONG)	NonDelegatingAddRef();
	STDMETHODIMP_(ULONG)	NonDelegatingRelease();

	HRESULT					SetMediaType(const CMediaType* mt);
	HRESULT					CheckMediaType(const CMediaType* mtIn);

	HRESULT					CompleteConnect(IPin *pReceivePin);

	STDMETHODIMP			Receive(IMediaSample * pSample);
	STDMETHODIMP			EndOfStream();
	STDMETHODIMP			BeginFlush();
	STDMETHODIMP			EndFlush();
	STDMETHODIMP			NewSegment(REFERENCE_TIME tStart,
										REFERENCE_TIME tStop,
										double dRate);

	CMediaType&				CurrentMediaType();

protected:
    flLong					_referenceCount;
	
	CVolumeGraph*			_volumeGraph;
};
//------------------------------------------------------------------------------
#endif // __VolumeGraphInputPin_h__
