/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flVolumeGraph/VolumeGraphOutputPin.h>
#include <flVolumeGraph/VolumeGraph.h>
#include <flBase/flNotify.h>
//------------------------------------------------------------------------------
CVolumeGraphOutputPin::CVolumeGraphOutputPin(TCHAR *pObjectName,
											CVolumeGraph *volumeGraph,
											HRESULT * phr,
											LPCWSTR pName) :
CBaseOutputPin(pObjectName, volumeGraph, &volumeGraph->_filterLock, phr, pName)
{
	_referenceCount	= 0;
	_volumeGraph	= volumeGraph;
	_position		= NULL;
}
//------------------------------------------------------------------------------
CVolumeGraphOutputPin::~CVolumeGraphOutputPin()
{
	if (_position != NULL)
	{
		_position->Release();
		_position = NULL;
	}
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
STDMETHODIMP
CVolumeGraphOutputPin::QueryId(LPWSTR * Id)
{
	*Id = (LPWSTR)CoTaskMemAlloc(8);
	if (*Id==NULL)
		return E_OUTOFMEMORY;
	IntToWstr(_volumeGraph->GetOutputPinIndex(this) + _volumeGraph->_inputPins.getSize(), *Id);
	return NOERROR;
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
STDMETHODIMP_(ULONG)
CVolumeGraphOutputPin::NonDelegatingAddRef()
{
	CAutoLock lock(&_volumeGraph->_filterLock);

    _referenceCount++;
    ASSERT(_referenceCount > 0);

	return _referenceCount;
}
//------------------------------------------------------------------------------
STDMETHODIMP_(ULONG)
CVolumeGraphOutputPin::NonDelegatingRelease()
{
    CAutoLock lock(&_volumeGraph->_filterLock);

    _referenceCount--;
    ASSERT(_referenceCount >= 0);

    if (_referenceCount <= 1)
	{
        flInt n = 2;
        if (_referenceCount == 1)
		{
            n = _volumeGraph->GetNumFreeInputPins();
        }

        if (n >= 2) 
		{
            _referenceCount = 0;
            _volumeGraph->DeleteOutPin(this);
            return (ULONG)0;
        }
    }

	return _referenceCount;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CVolumeGraphOutputPin::NonDelegatingQueryInterface(REFIID riid, void **ppv)
{
	CheckPointer(ppv, E_POINTER);
	ValidateReadWritePtr(ppv, sizeof(PVOID));
	*ppv = NULL;

	if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
	{
		ASSERT(_volumeGraph->GetInputPin(this) != NULL);

		if (_position == NULL)
		{
			HRESULT hr = CreatePosPassThru(
							GetOwner(),
							FALSE,
							(IPin *)_volumeGraph->GetInputPin(this),
							&_position);
			if (FAILED(hr))
				return hr;
		}
		return _position->QueryInterface(riid, ppv);
	}
	else
	{
		return CBaseOutputPin::NonDelegatingQueryInterface(riid, ppv);
	}
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
HRESULT
CVolumeGraphOutputPin::GetMediaType(int iPosition, CMediaType *pMediaType)
{
	ASSERT(_volumeGraph->GetInputPin(this) != NULL);

	if (iPosition == 0 && _volumeGraph->GetInputPin(this)->IsConnected())
		return _volumeGraph->GetMediaType(this, pMediaType);
	else
		return VFW_S_NO_MORE_ITEMS;
}
//------------------------------------------------------------------------------
HRESULT
CVolumeGraphOutputPin::CheckMediaType(const CMediaType* mtOut)
{
	ASSERT(_volumeGraph->GetInputPin(this) != NULL);
	if (_volumeGraph->GetInputPin(this)->IsConnected() == FALSE)
		return E_INVALIDARG;

	return _volumeGraph->CheckMediaType(this, mtOut);
}
//------------------------------------------------------------------------------
HRESULT
CVolumeGraphOutputPin::DecideBufferSize(IMemAllocator * pAlloc,
								ALLOCATOR_PROPERTIES *pProp)
{
	return _volumeGraph->DecideBufferSize(this, pAlloc, pProp);
}
//------------------------------------------------------------------------------
STDMETHODIMP
CVolumeGraphOutputPin::Notify(IBaseFilter *pSender, Quality q)
{
	return S_FALSE;
}
//------------------------------------------------------------------------------
CMediaType&
CVolumeGraphOutputPin::CurrentMediaType()
{
	return m_mt;
}
//------------------------------------------------------------------------------
