/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __VolumeGraphOutputPin_h__
#define __VolumeGraphOutputPin_h__
//------------------------------------------------------------------------------
#include <flVolumeGraph/VolumeGraph.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CVolumeGraph;
//------------------------------------------------------------------------------
class CVolumeGraphOutputPin : public CBaseOutputPin
{
friend class CVolumeGraph;

public:
	CVolumeGraphOutputPin(TCHAR *pObjectName,
						CVolumeGraph *volumeGraph,
						HRESULT * phr,
						LPCWSTR pName);
	~CVolumeGraphOutputPin();

public:
	STDMETHODIMP			QueryId(LPWSTR * Id);

	STDMETHODIMP_(ULONG)	NonDelegatingAddRef();
	STDMETHODIMP_(ULONG)	NonDelegatingRelease();
	STDMETHODIMP			NonDelegatingQueryInterface(REFIID riid, void **ppv);

	HRESULT					GetMediaType(int iPosition, CMediaType *pMediaType);
	HRESULT					CheckMediaType(const CMediaType* mtOut);

	HRESULT					DecideBufferSize(IMemAllocator * pAlloc,
											ALLOCATOR_PROPERTIES *pProp);

	STDMETHODIMP			Notify(IBaseFilter * pSender, Quality q);

	CMediaType&				CurrentMediaType();

protected:
	flInt					_referenceCount;

	CVolumeGraph*			_volumeGraph;
	IUnknown*				_position;
};
//------------------------------------------------------------------------------
#endif // __VolumeGraphOutputPin_h__
