/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __VolumeGraphProp_h__
#define __VolumeGraphProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flVolumeGraph/_IVolumeGraph.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IVolumeGraph.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flGraphWindow;
//------------------------------------------------------------------------------
class CVolumeGraphProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CVolumeGraphProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

	void		createGraphWindow(HWND hWnd);
	void		deleteGraphWindow();

	void		setupGraph();
	void		drawGraph();
	
private:
    IVolumeGraph*			_volumeGraph;
	_IVolumeGraph*			__volumeGraph;

	UINT_PTR				_timer;

	flBool					_paused;
	flGraphWindow*			_graphWindowL;
	flGraphWindow*			_graphWindowR;

	// Property
	flInt					_displayTime;
};
//------------------------------------------------------------------------------
#endif //__VolumeGraphProp_h__
