/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <flVolumeGraph/flGraph.h>
#include <limits.h>
//------------------------------------------------------------------------------
flGraph::flGraph()
{
	_position		= 0;
	clear();

	_color[0]		= 0x00;
	_color[1]		= 0xff;
	_color[2]		= 0x00;
}
//------------------------------------------------------------------------------
flGraph::~flGraph()
{
}
//------------------------------------------------------------------------------
void
flGraph::draw(HDC hdc, flUInt w, flUInt h, flUInt step, flInt rangeMin, flInt rangeMax)
{
	HPEN pen;
	HGDIOBJ oldPen;

	flUInt j;
	flFloat x, y;

	flFloat a = flFloat(h) / flFloat(rangeMin - rangeMax);
	flFloat b = -a * rangeMax;
	flFloat xi = w / flFloat(step);

	pen = CreatePen(PS_SOLID, 1, RGB(_color[0], _color[1], _color[2]));
	oldPen = SelectObject(hdc, pen);

	for(x = (flFloat)w, j = 0; 0 < x; x -= xi, j++)
	{
		flInt point = getPoint(j);
		if (point == INVALID_POINT)
			break;

		y = point * a + b;

		if (j == 0)
			MoveToEx(hdc, (flInt)x, (flInt)y, NULL);
		else
			LineTo(hdc, (flInt)x, (flInt)y);
	}

	SelectObject(hdc, oldPen);
	DeleteObject(pen);
}
//------------------------------------------------------------------------------
void
flGraph::point(flInt value)
{
	_data[_position++] = value;
	if (MAX_DATA <= _position)
		_position = 0;
}
//------------------------------------------------------------------------------
void
flGraph::clear()
{
	_position = 0;
	for(flUInt i = 0; i < MAX_DATA; i++)
		_data[i] = INVALID_POINT;
}
//------------------------------------------------------------------------------
flInt
flGraph::getPoint(flUInt index) const
{
	if (MAX_DATA <= index)
		return INVALID_POINT;

	flInt idx = _position - index - 1;
	if (idx < 0)
		idx = MAX_DATA + idx;
	return _data[idx];
}
//------------------------------------------------------------------------------
void
flGraph::setColor(const flByte* color)
{
	memcpy(_color, color, sizeof(_color));
}
//------------------------------------------------------------------------------
const flByte*
flGraph::getColor() const
{
	return _color;
}
//------------------------------------------------------------------------------
