/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flGraph_h__
#define __flGraph_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#define MAX_DATA			2048
#define INVALID_POINT		INT_MAX
//------------------------------------------------------------------------------
class flGraph
{
public:
	flGraph();
	~flGraph();

public:
	void			draw(HDC hdc, flUInt w, flUInt h, flUInt step, flInt rangeMin, flInt rangeMax);

	void			point(flInt value);
	void			clear();

	void			setColor(const flByte* color);
	const flByte*	getColor() const;

private:
	flInt			getPoint(flUInt index) const;

private:
	flInt		_position;
	flInt		_data[MAX_DATA];

	flByte		_color[3];
};
//------------------------------------------------------------------------------
#endif //__flGraph_h__
