/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flGraphWindow_h__
#define __flGraphWindow_h__
//------------------------------------------------------------------------------
#include <flVolumeGraph/flGraph.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flGraphWindow
{
public:
	flGraphWindow(HWND parentWindow);
	~flGraphWindow();

public:
	void			setPosition(flInt x, flInt y);
	void			getPosition(flInt& x, flInt& y) const;

	void			setSize(flUInt width, flUInt height);
	void			getSize(flUInt& width, flUInt& height) const;

public:
	void			setStep(flUInt step);
	flUInt			getStep() const;

	void			setRange(flInt min, flInt max);
	void			getRange(flInt& min, flInt& max) const;

public:
	void			setNumGraph(flUInt count);
	flUInt			getNumGraph() const;

	void			setGraphColor(flUInt index, const flByte* color);
	const flByte*	getGraphColor(flUInt index) const;

	void			pointGraph(flUInt index, flInt value);
	void			clearGraph(flUInt index);
	void			clearGraph();

public:
	void			draw();

private:
	void			draw(HWND hWnd);
	void			createMemDC(flUInt width, flUInt height);

private:
	virtual	LRESULT	wm_proc(HWND hWnd, UINT msg,
								WPARAM wParam, LPARAM lParam);

	static LRESULT CALLBACK	windowProc(
						HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

protected:
	HWND				_window;

	flArray<flGraph>	_graphs;
	flUInt				_step;
	flInt				_rangeMin;
	flInt				_rangeMax;


	HDC					_memDC;
	HBITMAP				_bitmap;

};
//------------------------------------------------------------------------------
#endif //__flGraphWindow_h__
