/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __VolumeIndicator_h__
#define __VolumeIndicator_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flPCMAudio.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IVolumeIndicator.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flAbsoluteTime;
//------------------------------------------------------------------------------
class CVolumeIndicator :
			public CTransInPlaceFilter,
			public CPersistStream, 
			public IVolumeIndicator,
			public ISpecifyPropertyPages
{
public:
	static CUnknown * WINAPI	CreateInstance(LPUNKNOWN punk, HRESULT *phr);

private:
	CVolumeIndicator(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CVolumeIndicator();

public:
	DECLARE_IUNKNOWN;

public:
	STDMETHODIMP			NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	HRESULT					SetMediaType(PIN_DIRECTION direction, const CMediaType* pmt);
	HRESULT					CheckInputType(const CMediaType* mtIn);

	// IPersistStream
    STDMETHODIMP			GetClassID(CLSID *pClsid);
	HRESULT					WriteToStream(IStream *pStream);
    HRESULT					ReadFromStream(IStream *pStream);
	DWORD					GetSoftwareVersion(void);
	int						SizeMax();

	// IVolumeIndicator
	STDMETHODIMP			get_Channels(flUShort* channels);
	STDMETHODIMP			get_BitsPerSample(flUShort* bitsPerSample);
	STDMETHODIMP			get_SamplesPerSec(flUInt* samplesPerSec);
	STDMETHODIMP			get_Volume(VolumeInfo *volume);
	STDMETHODIMP			get_EvaluationTime(flULong *time);
	STDMETHODIMP			put_EvaluationTime(flULong time);

	// ISpecifyPropertyPages
	STDMETHODIMP			GetPages(CAUUID *pPages);

private:
	// CTransformInPlaceFilter Overrides
	HRESULT					Transform(IMediaSample *pSample);

private:
	void					computeVolume(VolumeInfo *volume, flULong evalTime);

protected:
    CCritSec				_filterLock;

	flAbsoluteTime*			_absTime;

	flPCMAudio*				_pcmAudio;
	flULong					_evalTime;
};
//------------------------------------------------------------------------------
#endif //__VolumeIndicator_h__
