/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flVolumeIndicator/VolumeIndicatorProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CVolumeIndicatorProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CVolumeIndicatorProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CVolumeIndicatorProp::CVolumeIndicatorProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("VolumeIndicatorProp"),pUnk,
                      IDD_VOLUMEINDICATORPROP,
                      IDS_VOLUMEINDICATORPROPTITLE),
    _volumeIndicator(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CVolumeIndicatorProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CVolumeIndicatorProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_EVALTIME_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_EVALTIME_EDIT), sz, STR_MAX_LENGTH);

					_evalTime = atoi(sz);
					if (500 < _evalTime)		_evalTime = 500;
					else if (_evalTime < 1)		_evalTime = 1;

					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{

			if (wParam == _timer1)
			{
				VolumeInfo volume;
				_volumeIndicator->get_Volume(&volume);

				SendMessage(GetDlgItem(m_Dlg, IDC_LVOLUME_PROGRESS),
					PBM_SETPOS, (flInt)volume.left / 100 + 30, 0);
				SendMessage(GetDlgItem(m_Dlg, IDC_RVOLUME_PROGRESS),
					PBM_SETPOS, (flInt)volume.right / 100 + 30, 0);
			}
			else
			{
				TCHAR sz[256];
				flUShort sval;
				flUInt ival;

				_volumeIndicator->get_Channels(&sval);
				_stprintf(sz, "%d", sval);
				Static_SetText(GetDlgItem(m_Dlg, IDC_CHANNEL_VALUE), sz);

				_volumeIndicator->get_BitsPerSample((flUShort *)&sval);
				_stprintf(sz, "%d", sval);
				Static_SetText(GetDlgItem(m_Dlg, IDC_BITCNT_VALUE), sz);

				_volumeIndicator->get_SamplesPerSec((flUInt *)&ival);
				_stprintf(sz, "%d", ival);
				Static_SetText(GetDlgItem(m_Dlg, IDC_FREQUENCY_VALUE), sz);
			}

			Sleep(0);
			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CVolumeIndicatorProp::OnConnect(IUnknown *pUnknown)
{
	ASSERT(_volumeIndicator == NULL);

	HRESULT hr = pUnknown->QueryInterface(IID_IVolumeIndicator, (void **) &_volumeIndicator);
	if (FAILED(hr))
	{
		return E_NOINTERFACE;
	}

	ASSERT(_volumeIndicator);
	_volumeIndicator->get_EvaluationTime(&_evalTime);

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CVolumeIndicatorProp::OnDisconnect()
{
	if (_volumeIndicator == NULL)
	{
		return E_UNEXPECTED;
	}

	_volumeIndicator->Release();
	_volumeIndicator = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CVolumeIndicatorProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CVolumeIndicatorProp::OnApplyChanges()
{
	_volumeIndicator->put_EvaluationTime(_evalTime);

	KillTimer(m_Dlg, _timer1);
	_timer1 = SetTimer(m_Dlg, 1, _evalTime, NULL);

	m_bDirty = FALSE;
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CVolumeIndicatorProp::setupControls()
{
	TCHAR sz[256];
	_stprintf(sz, "%d", _evalTime);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_EVALTIME_EDIT), sz);

	SendMessage(GetDlgItem(m_Dlg, IDC_LVOLUME_PROGRESS),
		PBM_SETRANGE, 0, MAKELPARAM(0, 30));
	SendMessage(GetDlgItem(m_Dlg, IDC_RVOLUME_PROGRESS),
		PBM_SETRANGE, 0, MAKELPARAM(0, 30));

	// Setup Timer
	_timer1 = SetTimer(m_Dlg, 1, _evalTime, NULL);
	_timer2 = SetTimer(m_Dlg, 2, 500, NULL);
}
//------------------------------------------------------------------------------
void
CVolumeIndicatorProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer1);
	KillTimer(m_Dlg, _timer2);
}
//------------------------------------------------------------------------------
