//------------------------------------------------------------------------------
#include <cstdio>
#include <cstring>
//------------------------------------------------------------------------------
struct rgb_rec
{
	rgb_rec()
	{
		memset(this, 0, sizeof(rgb_rec));
	}
	~rgb_rec()
	{
		delete [] tmp;
		delete [] tmpR;
		delete [] tmpG;
		delete [] tmpB;
		delete [] tmpA;
		delete [] rowStart;
		delete [] rowSize;
	}

	unsigned short	imagic;
	unsigned short	type;
	unsigned short	dim;
	unsigned short	sizeX, sizeY, sizeZ;
	unsigned long	min, max;
	unsigned long	wasteBytes;
	char			name[80];
	unsigned long	colorMap;
	unsigned char*	tmp;
	unsigned char*	tmpR;
	unsigned char*	tmpG;
	unsigned char*	tmpB;
	unsigned char*	tmpA;
	unsigned long	rleEnd;
	unsigned int*	rowStart;
	int*			rowSize;
	FILE*			fp;
};
//------------------------------------------------------------------------------
static void
swap_shorts(unsigned short* array, long length)
{
	unsigned long	b1, b2;
	unsigned char*	ptr;

	ptr = (unsigned char*)array;
	while (length--)
	{
		b1 = *ptr++;
		b2 = *ptr++;
		*array++ = (unsigned short)((b1 << 8) | (b2));
	}
}
//------------------------------------------------------------------------------
static void
swap_longs(unsigned int* array, long length)
{
	unsigned long	b1, b2, b3, b4;
	unsigned char*	ptr;

	ptr = (unsigned char*)array;
	while (length--)
	{
		b1 = *ptr++;
		b2 = *ptr++;
		b3 = *ptr++;
		b4 = *ptr++;
		*array++ = (b1 << 24) | (b2 << 16) | (b3 << 8) | (b4);
	}
}
//------------------------------------------------------------------------------
static void
open_raw(rgb_rec& rec)
{
	union
	{
		int		testWord;
		char	testByte[4];
	} endianTest;

	endianTest.testWord = 1;
	bool	swapFlag = (endianTest.testByte[0] == 1);

	fread(&rec, 1, 12, rec.fp);
	if (swapFlag)
		swap_shorts(&rec.imagic, 6);

	rec.tmp		= new unsigned char[rec.sizeX*256];
	rec.tmpR	= new unsigned char[rec.sizeX*256];
	rec.tmpG	= new unsigned char[rec.sizeX*256];
	rec.tmpB	= new unsigned char[rec.sizeX*256];

	if (rec.sizeZ == 4)
		rec.tmpA = new unsigned char[rec.sizeX*256];

	if ((rec.type & 0xFF00) == 0x0100)	// RLE
	{
		int	ss = rec.sizeY * rec.sizeZ;
		rec.rowStart	= new unsigned int[ss];
		rec.rowSize		= new int[ss];
		rec.rleEnd		= 512 + (2 * ss * sizeof(unsigned int));
		fseek(rec.fp, 512, SEEK_SET);
		fread(rec.rowStart, 1, ss * sizeof(unsigned int), rec.fp);
		fread(rec.rowSize,  1, ss * sizeof(int), rec.fp);
		if (swapFlag)
		{
			swap_longs(rec.rowStart, (long)ss);
			swap_longs((unsigned int*)rec.rowSize, (long)ss);
		}
	}
}
//------------------------------------------------------------------------------
static void
get_row(rgb_rec& rec, unsigned char* buf, int y, int z)
{
	unsigned char*	iPtr;
	unsigned char*	oPtr;
	unsigned char	pixel;
	int				count;
	bool			done = false;

	if ((rec.type & 0xFF00) == 0x0100)	// RLE
	{
		fseek(rec.fp, (long)rec.rowStart[y+z*rec.sizeY], SEEK_SET);
		fread(rec.tmp, 1, (unsigned int)rec.rowSize[y+z*rec.sizeY], rec.fp);
	    
		iPtr	= rec.tmp;
		oPtr	= buf;
		while (!done)
		{
			pixel = *iPtr++;
			count = (int)(pixel & 0x7F);

			if (!count)
			{
				done = true;
				return;
			}
			if (pixel & 0x80)
			{
				while (count--)
					*oPtr++ = *iPtr++;
			}
			else
			{
				pixel = *iPtr++;
				while (count--)
					*oPtr++ = pixel;
			}
		}
	}
	else
	{
		fseek(rec.fp, 512+(y*rec.sizeX)+(z*rec.sizeX*rec.sizeY),
			SEEK_SET);
		fread(buf, 1, rec.sizeX, rec.fp);
	}
}
//------------------------------------------------------------------------------
bool
read_rgb(FILE* fp,
		 unsigned int& width,
		 unsigned int& height,
		 unsigned int& components,
		 unsigned char*& image)
{
	rgb_rec			rec;
	unsigned char*	dst;
	unsigned int	i, j;

	rec.fp	= fp;
	open_raw(rec);

	width		= rec.sizeX;
	height		= rec.sizeY;
	components	= rec.sizeZ;
	image		= new unsigned char[width * height * components];

	dst = image;
	for (i = 0; i < height; ++i)
	{
		get_row(rec, rec.tmpR, i, 0);
		get_row(rec, rec.tmpG, i, 1);
		get_row(rec, rec.tmpB, i, 2);
		if (components > 3)
			get_row(rec, rec.tmpA, i, 3);

		for (j = 0; j < width; ++j)
		{
			*dst++ = *(rec.tmpR + j);
			*dst++ = *(rec.tmpG + j);
			*dst++ = *(rec.tmpB + j);
			if (components > 3)
				*dst++ = *(rec.tmpA + j);
		}
	}

	return true;
}
//------------------------------------------------------------------------------

